/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.ClauseADQL;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class In
implements ADQLConstraint {
    private ADQLOperand leftOp;
    private ADQLQuery subQuery;
    private ADQLList<ADQLOperand> list;
    private boolean notIn = false;

    public In(ADQLOperand aDQLOperand, ADQLQuery aDQLQuery) throws NullPointerException {
        this(aDQLOperand, aDQLQuery, false);
    }

    public In(ADQLOperand aDQLOperand, ADQLQuery aDQLQuery, boolean bl) throws NullPointerException {
        this.setOperand(aDQLOperand);
        this.setSubQuery(aDQLQuery);
        this.setNotIn(bl);
    }

    public In(ADQLOperand aDQLOperand, ADQLOperand[] aDQLOperandArray) throws NullPointerException {
        this(aDQLOperand, aDQLOperandArray, false);
    }

    public In(ADQLOperand aDQLOperand, ADQLOperand[] aDQLOperandArray, boolean bl) throws NullPointerException {
        this.setOperand(aDQLOperand);
        this.setValuesList(aDQLOperandArray);
        this.setNotIn(bl);
    }

    public In(ADQLOperand aDQLOperand, ADQLList<ADQLOperand> aDQLList) throws NullPointerException {
        this(aDQLOperand, aDQLList, false);
    }

    public In(ADQLOperand aDQLOperand, ADQLList<ADQLOperand> aDQLList, boolean bl) throws NullPointerException {
        this.setOperand(aDQLOperand);
        this.setValuesList(aDQLList);
        this.setNotIn(bl);
    }

    public In(In in) throws Exception {
        this.leftOp = (ADQLOperand)in.leftOp.getCopy();
        if (in.hasSubQuery()) {
            this.setSubQuery((ADQLQuery)in.subQuery.getCopy());
        } else {
            this.setValuesList((ADQLList)in.list.getCopy());
        }
        this.notIn = in.notIn;
    }

    public final ADQLOperand getOperand() {
        return this.leftOp;
    }

    public void setOperand(ADQLOperand aDQLOperand) throws NullPointerException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to set a left operand NULL in an IN constraint !");
        }
        this.leftOp = aDQLOperand;
    }

    public final ADQLQuery getSubQuery() {
        return this.subQuery;
    }

    public final boolean hasSubQuery() {
        return this.subQuery != null;
    }

    public void setSubQuery(ADQLQuery aDQLQuery) throws NullPointerException {
        if (aDQLQuery == null) {
            throw new NullPointerException("Impossible to set a sub-query NULL in an IN constraint !");
        }
        this.list = null;
        this.subQuery = aDQLQuery;
    }

    public final ADQLList<ADQLOperand> getValuesList() {
        return this.list;
    }

    public void setValuesList(ADQLOperand[] aDQLOperandArray) throws NullPointerException {
        if (aDQLOperandArray == null) {
            throw new NullPointerException("Impossible to set a values list NULL in an IN constraint !");
        }
        if (aDQLOperandArray.length > 0) {
            this.subQuery = null;
            this.list = new ClauseADQL<ADQLOperand>();
            for (int i = 0; i < aDQLOperandArray.length; ++i) {
                this.list.add(aDQLOperandArray[i]);
            }
        }
    }

    public void setValuesList(ADQLList<ADQLOperand> aDQLList) throws NullPointerException {
        if (aDQLList == null) {
            throw new NullPointerException("Impossible to set a values list NULL in an IN constraint !");
        }
        this.subQuery = null;
        this.list = aDQLList;
    }

    public final boolean isNotIn() {
        return this.notIn;
    }

    public void setNotIn(boolean bl) {
        this.notIn = bl;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new In(this);
    }

    @Override
    public String getName() {
        return this.notIn ? "NOT IN" : "IN";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return In.this.leftOp;
                }
                if (this.index == 1) {
                    return In.this.hasSubQuery() ? In.this.subQuery : In.this.list;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                }
                if (this.index == 0) {
                    if (!(aDQLObject instanceof ADQLOperand)) throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                    In.this.leftOp = (ADQLOperand)aDQLObject;
                    return;
                } else {
                    if (this.index != 1) return;
                    if (In.this.hasSubQuery() && aDQLObject instanceof ADQLQuery) {
                        In.this.subQuery = (ADQLQuery)aDQLObject;
                        return;
                    } else {
                        if (In.this.hasSubQuery() || !(aDQLObject instanceof ADQLList)) throw new UnsupportedOperationException("Impossible to replace an " + (In.this.hasSubQuery() ? "ADQLQuery" : "ADQLList<ADQLOperand>") + " by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        In.this.list = (ADQLList)aDQLObject;
                    }
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                if (this.index == 0) {
                    throw new UnsupportedOperationException("Impossible to remove the left operand of the IN constraint !");
                }
                if (this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove the " + (In.this.hasSubQuery() ? "sub-query" : "values list") + " of the IN constraint !");
                }
            }
        };
    }

    @Override
    public String toADQL() {
        return this.leftOp.toADQL() + " " + this.getName() + " (" + (this.hasSubQuery() ? this.subQuery.toADQL() : this.list.toADQL()) + ")";
    }
}

